;; This example shows how to split the screen using the CPC+
;; If you want to do the same effect on the CPC, then you will
;; need to use the "rupture"/"vertical splitting" technique.
;;
;; This example is designed for CPC+ only and will
;; not work on CPC or KC Compact.
;;
;;;; This example will compile with the MAXAM assembler
;; or the built-in assembler of WinAPE32.


;; NOTE - For this example to work, the code must not
;; be in the range &4000-&7fff inclusive. The ASIC registers
;; are paged into this range, and the code would not be
;; visible to the CPU if it was also in this range.
org &8000


;;--------------------------------------------------
;; STEP 1 - Unlock CPC+ additional features
;; unlock asic to gain access to asic registers

di
ld b,&bc
ld hl,sequence
ld e,17
.seq 
ld a,(hl)
out (c),a
inc hl
dec e
jr nz,seq
ei


;;---------------------------------------------------
;; STEP 2 - Set display start address for display before split

;; this address corresponds to a start of &c000
ld hl,&3000

;; set display start address (high)
ld bc,&bc0c
out (c),c
inc b
out (c),h

;; set display start address (low)
ld bc,&bc0d
out (c),c
inc b
out (c),l

;;---------------------------------------------------
;; STEP 3 - Set display start address for display after split
;;
;; - The split is refreshed by the ASIC, so as soon as it has been initialised
;;   it will remain active until it is disabled (by writing 0 as the scan-line for the split)
;;   No extra CPU time is required to maintain the split.
;;
;; - The split address is defined the same as the CRTC display start address
;;
;; - The split address is in the same order as the CRTC display start address 
;;   (high byte followed by low byte)

;; page-in asic registers to &4000-&7fff
ld bc,&7fb8
out (c),c

;; set scan-line that split will activate on
ld a,100
ld (&6801),a

;; set screen address of split:
;; this address corresponds to start of &4000
ld hl,&1000

ld a,h
ld (&6802),a
ld a,l
ld (&6803),a

;; page-out asic registers
ld bc,&7fa0
out (c),c

;;----------------------------------------------------


ret






;;----------------------------------------------------------
;; this is the sequence to unlock the ASIC extra features
.sequence
defb &ff,&00,&ff,&77,&b3,&51,&a8,&d4,&62,&39,&9c,&46,&2b,&15,&8a,&cd,&ee
